/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.adventurez.entity.nonliving.TinyEyeEntity;
import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TheEyeEntity
extends FlyingMob {
    private static final EntityDataAccessor<Integer> BEAM_TARGET_ID;
    public static final EntityDataAccessor<Integer> INVUL_TIMER;
    private int f_31429_;
    @Nullable
    private final ServerBossEvent bossBar;
    private LivingEntity cachedBeamTarget;
    private boolean gotDamage;
    private int attackTpCounter;
    private int deathTimer;
    private int duplicationTimer = 0;
    private final boolean isVoidZLoaded = FabricLoader.getInstance().isModLoaded("voidz");

    public TheEyeEntity(EntityType<? extends TheEyeEntity> entityType, Level world) {
        super(entityType, world);
        if (this.duplicationTimer <= 0) {
            this.bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
            this.f_21364_ = 80;
        } else {
            this.bossBar = null;
            this.f_21364_ = 0;
        }
        this.f_21342_ = new EyeMoveControl(this);
    }

    public static AttributeSupplier.Builder createTheEntityAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 800.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22284_, 5.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ShootBulletGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FireBeamGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new DuplicateAttack(this));
        this.f_21345_.m_25352_(3, (Goal)new FlyRandomlyGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INVUL_TIMER, (Object)0);
        this.f_19804_.m_135372_(BEAM_TARGET_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Invul", this.getInvulnerableTimer());
        tag.m_128405_("DeathTimer", this.deathTimer);
        tag.m_128405_("DuplicationTimer", this.duplicationTimer);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setInvulTimer(tag.m_128451_("Invul"));
        if (this.m_8077_() && this.bossBar != null) {
            this.bossBar.m_6456_(this.m_5446_());
        }
        this.deathTimer = tag.m_128451_("DeathTimer");
        this.duplicationTimer = tag.m_128451_("DuplicationTimer");
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        if (this.bossBar != null) {
            this.bossBar.m_6456_(this.m_5446_());
        }
    }

    protected SoundEvent m_7515_() {
        return SoundInit.EYE_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.EYE_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.EYE_DEATH_EVENT;
    }

    public float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.1f;
    }

    public void m_8107_() {
        Vec3 vec3d = this.m_20184_().m_82542_(0.8, 0.5, 0.8);
        if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
            LivingEntity entity = this.m_5448_();
            double d = Math.max(0.0, vec3d.f_82480_);
            if (this.m_20186_() < entity.m_20186_() + 12.0) {
                d += 0.3 - d * 0.6;
            } else if (this.m_20186_() > entity.m_20186_() + 26.0) {
                d -= 0.3 - d * 0.6;
            }
            vec3d = new Vec3(vec3d.f_82479_, d, vec3d.f_82481_);
            Vec3 vec3d2 = new Vec3(entity.m_20185_() - this.m_20185_(), 0.0, entity.m_20189_() - this.m_20189_());
            if (this.m_20238_(vec3d2) > 16.0) {
                Vec3 vec3d3 = vec3d2.m_82541_();
                vec3d = vec3d.m_82520_(vec3d3.f_82479_ * 0.05 - vec3d.f_82479_ * 0.05, 0.0, vec3d3.f_82481_ * 0.05 - vec3d.f_82481_ * 0.05);
            }
        }
        this.m_20256_(vec3d);
        super.m_8107_();
    }

    public void m_8024_() {
        if (!this.m_20068_()) {
            this.m_20242_(true);
        }
        if (this.getInvulnerableTimer() > 0) {
            int j = this.getInvulnerableTimer() - 1;
            if (j <= 0) {
                this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20188_(), this.m_20189_(), 7.0f, false, Level.ExplosionInteraction.MOB);
                if (!this.m_20067_()) {
                    this.m_9236_().m_6798_(1023, this.m_20183_(), 0);
                }
            }
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            this.setInvulTimer(j);
        } else {
            super.m_8024_();
            LivingEntity livingEntity = this.m_5448_();
            if (livingEntity != null && livingEntity.m_6084_()) {
                if (this.attackTpCounter >= 120 && !this.hasBeamTarget()) {
                    for (int counter = 0; counter < 100; ++counter) {
                        float randomFloat = this.m_9236_().m_213780_().m_188501_() * ((float)Math.PI * 2);
                        int posX = livingEntity.m_20183_().m_123341_() + Mth.m_14143_((float)(Mth.m_14089_((float)randomFloat) * 9.0f + (float)livingEntity.m_9236_().m_213780_().m_188503_(12)));
                        int posZ = livingEntity.m_20183_().m_123343_() + Mth.m_14143_((float)(Mth.m_14031_((float)randomFloat) * 9.0f + (float)livingEntity.m_9236_().m_213780_().m_188503_(12)));
                        int posY = livingEntity.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, posX, posZ) + 10 + livingEntity.m_9236_().m_213780_().m_188503_(12);
                        BlockPos teleportPos = new BlockPos(posX, posY, posZ);
                        if (!livingEntity.m_9236_().m_46812_(teleportPos.m_123341_() - 4, teleportPos.m_123342_() - 4, teleportPos.m_123343_() - 4, teleportPos.m_123341_() + 4, teleportPos.m_123342_() + 4, teleportPos.m_123343_() + 4) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)livingEntity.m_9236_(), (BlockPos)teleportPos, EntityInit.THE_EYE)) continue;
                        this.f_21365_.m_24946_((double)teleportPos.m_123341_(), (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_());
                        if (!this.m_9236_().m_5776_()) {
                            livingEntity.m_20324_((double)teleportPos.m_123341_(), (double)teleportPos.m_123342_(), (double)teleportPos.m_123343_());
                        }
                        livingEntity.m_9236_().m_5594_(null, teleportPos, SoundEvents.f_11852_, SoundSource.HOSTILE, 1.0f, 1.0f);
                        if (this.m_9236_().m_5776_()) {
                            this.despawnParticlesServer(livingEntity);
                        }
                        this.attackTpCounter = -100;
                        break;
                    }
                } else {
                    ++this.attackTpCounter;
                }
            }
            if (this.f_31429_ > 0) {
                --this.f_31429_;
                if (this.f_31429_ == 0 && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                    int j = Mth.m_14107_((double)this.m_20186_());
                    int n = Mth.m_14107_((double)this.m_20185_());
                    int o = Mth.m_14107_((double)this.m_20189_());
                    boolean bl = false;
                    for (int p = -1; p <= 1; ++p) {
                        for (int q = -1; q <= 1; ++q) {
                            for (int r = 0; r <= 3; ++r) {
                                int s = n + p;
                                int t = j + r;
                                int u = o + q;
                                BlockPos blockPos = new BlockPos(s, t, u);
                                BlockState blockState = this.m_9236_().m_8055_(blockPos);
                                if (!this.canDestroy(blockState)) continue;
                                bl = this.m_9236_().m_46953_(blockPos, true, (Entity)this) || bl;
                            }
                        }
                    }
                    if (bl) {
                        this.m_9236_().m_5898_((Player)null, 1022, this.m_20183_(), 0);
                    }
                }
            }
            if (this.f_19797_ % 20 == 0) {
                this.m_5634_(1.0f);
            }
            if (this.bossBar != null) {
                this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.duplicationTimer > 0) {
            --this.duplicationTimer;
            if (this.duplicationTimer == 20) {
                for (int i = 0; i < 50; ++i) {
                    double d = this.m_20185_() - 1.5 + (double)(this.m_9236_().m_213780_().m_188501_() * 3.0f);
                    double e = (float)this.m_20187_() + this.m_9236_().m_213780_().m_188501_() * 0.1f;
                    double f = this.m_20189_() - 1.5 + (double)(this.m_9236_().m_213780_().m_188501_() * 3.0f);
                    double g = (double)this.m_9236_().m_213780_().m_188501_() * 0.2;
                    double h = (double)this.m_9236_().m_213780_().m_188501_() * 0.1;
                    double l = (double)this.m_9236_().m_213780_().m_188501_() * 0.2;
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, d, e, f, 4, g, h, l, 1.0);
                }
                this.m_21557_(true);
            }
            if (this.duplicationTimer == 1) {
                this.m_146870_();
            }
        }
    }

    private boolean canDestroy(BlockState block) {
        return !block.m_60795_() && !block.m_60734_().m_204297_().m_203656_(TagInit.UNBREAKABLE_BLOCKS);
    }

    public void setEyeInvulnerabletime() {
        this.setInvulTimer(220);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (this.duplicationTimer <= 0) {
            this.bossBar.m_6543_(player);
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        if (this.bossBar != null) {
            this.bossBar.m_6539_(player);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!source.m_269533_(DamageTypeTags.f_268581_) && !(source.m_7639_() instanceof TheEyeEntity)) {
            if (this.getInvulnerableTimer() > 0 && !source.m_269533_(DamageTypeTags.f_268738_)) {
                return false;
            }
            Entity entity2 = source.m_7639_();
            if (entity2 != null && !(entity2 instanceof Player) && entity2 instanceof LivingEntity && ((LivingEntity)entity2).m_6336_() == this.m_6336_()) {
                return false;
            }
            if (this.f_31429_ <= 0) {
                this.f_31429_ = 20;
            }
            if (this.m_9236_().m_213780_().m_188501_() < 0.6f) {
                this.gotDamage = true;
            }
            return super.m_6469_(source, amount);
        }
        return false;
    }

    private boolean gotDamage() {
        if (this.gotDamage) {
            this.gotDamage = false;
            return true;
        }
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_147207_(MobEffectInstance effect, Entity entity) {
        return false;
    }

    public int getInvulnerableTimer() {
        return (Integer)this.f_19804_.m_135370_(INVUL_TIMER);
    }

    public void setInvulTimer(int ticks) {
        this.f_19804_.m_135381_(INVUL_TIMER, (Object)ticks);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return false;
    }

    private void setBeamTarget(int entityId) {
        this.f_19804_.m_135381_(BEAM_TARGET_ID, (Object)entityId);
    }

    public boolean hasBeamTarget() {
        return (Integer)this.f_19804_.m_135370_(BEAM_TARGET_ID) != 0;
    }

    @Nullable
    public LivingEntity getBeamTarget() {
        if (!this.hasBeamTarget()) {
            return null;
        }
        if (this.m_9236_().m_5776_()) {
            if (this.cachedBeamTarget != null) {
                return this.cachedBeamTarget;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(BEAM_TARGET_ID)).intValue());
            if (entity instanceof LivingEntity) {
                this.cachedBeamTarget = (LivingEntity)entity;
                return this.cachedBeamTarget;
            }
            return null;
        }
        return this.m_5448_();
    }

    public int getWarmupTime() {
        return 120;
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (BEAM_TARGET_ID.equals(data)) {
            this.cachedBeamTarget = null;
        }
    }

    public boolean m_6785_(double num) {
        return false;
    }

    public void m_6153_() {
        if (this.duplicationTimer <= 0) {
            ++this.deathTimer;
            this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.005, 0.0));
            this.m_21557_(true);
            this.m_6710_(null);
            if (this.m_9236_().m_5776_()) {
                this.despawnParticlesServer((LivingEntity)this);
            }
            if (!this.m_9236_().m_5776_()) {
                this.bossBar.m_142711_(0.0f);
                BlockPos deathPos = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
                if (this.deathTimer == 20 && !this.isVoidZLoaded) {
                    AABB box = new AABB(this.m_20183_());
                    List list = this.m_9236_().m_6443_(Player.class, box.m_82400_(128.0), EntitySelector.f_20408_);
                    for (int i = 0; i < list.size(); ++i) {
                        Player playerEntity = (Player)list.get(i);
                        if (!(playerEntity instanceof Player)) continue;
                        playerEntity.m_7292_(new MobEffectInstance(EffectInit.FAME, 48000, 0, false, false, true));
                    }
                }
                if (this.deathTimer == 140) {
                    this.m_9236_().m_5594_(null, deathPos, SoundInit.EYE_DEATH_PLATFORM_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                if (this.deathTimer >= 200) {
                    for (int o = 0; o < 15; ++o) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)(deathPos.m_123341_() - 6 + this.m_9236_().m_213780_().m_188503_(13)), (double)(deathPos.m_123342_() - 1 + this.m_9236_().m_213780_().m_188503_(11)), (double)(deathPos.m_123343_() - 6 + this.m_9236_().m_213780_().m_188503_(13)), 0, 0.0, 0.0, 0.0, 0.01);
                        this.m_9236_().m_5594_(null, deathPos, SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    if (this.m_9236_().m_141928_() - 10 < deathPos.m_123342_()) {
                        deathPos = deathPos.m_6625_(deathPos.m_123342_() - this.m_9236_().m_141928_() + 10);
                    }
                    this.placeDeathStructure(deathPos);
                    if (this.isVoidZLoaded) {
                        this.m_9236_().m_7731_(deathPos.m_6630_(8).m_122012_().m_122024_(), ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("voidz", "void_portal"))).m_49966_(), 3);
                    } else {
                        this.m_9236_().m_7731_(deathPos.m_6630_(8).m_122012_().m_122024_(), Blocks.f_50260_.m_49966_(), 3);
                    }
                    if (this.m_9236_().m_213780_().m_188501_() <= 0.01f) {
                        this.m_19998_((ItemLike)ItemInit.PRIME_EYE);
                    }
                    this.m_146870_();
                }
            }
        } else {
            this.m_146870_();
        }
    }

    private void despawnParticlesServer(LivingEntity entity) {
        for (int i = 0; i < 12; ++i) {
            double d = this.f_19796_.m_188583_() * 0.025;
            double e = this.f_19796_.m_188583_() * 0.025;
            double f = this.f_19796_.m_188583_() * 0.025;
            double x = Mth.m_216263_((RandomSource)this.f_19796_, (double)(entity.m_20191_().f_82288_ - 1.5), (double)(entity.m_20191_().f_82291_ + 1.5));
            double y = Mth.m_216263_((RandomSource)this.f_19796_, (double)(entity.m_20191_().f_82289_ - 1.5), (double)(entity.m_20191_().f_82292_ + 1.5));
            double z = Mth.m_216263_((RandomSource)this.f_19796_, (double)(entity.m_20191_().f_82290_ - 1.5), (double)(entity.m_20191_().f_82293_ + 1.5));
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, d, e, f);
        }
    }

    private void placeDeathStructure(BlockPos blockPos) {
        StructureTemplateManager structureTemplateManager = ((ServerLevel)this.m_9236_()).m_215082_();
        Optional structure = structureTemplateManager.m_230407_(new ResourceLocation("adventurez:eyeland"));
        ((StructureTemplate)structure.get()).m_230328_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), blockPos.m_122025_(5).m_122013_(5), blockPos, new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(true), this.m_9236_().m_213780_(), 2);
    }

    static {
        INVUL_TIMER = SynchedEntityData.m_135353_(TheEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BEAM_TARGET_ID = SynchedEntityData.m_135353_(TheEyeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }

    private class EyeMoveControl
    extends MoveControl {
        private final TheEyeEntity theEyeEntity;
        private int collisionCheckCooldown;

        public EyeMoveControl(TheEyeEntity theEyeEntity2) {
            super((Mob)theEyeEntity2);
            this.theEyeEntity = theEyeEntity2;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.collisionCheckCooldown-- <= 0) {
                this.collisionCheckCooldown += this.theEyeEntity.m_217043_().m_188503_(5) + 2;
                Vec3 vec3d = new Vec3(this.f_24975_ - this.theEyeEntity.m_20185_(), this.f_24976_ - this.theEyeEntity.m_20186_(), this.f_24977_ - this.theEyeEntity.m_20189_());
                double d = vec3d.m_82553_();
                vec3d = vec3d.m_82541_();
                if (this.theEyeEntity.m_5448_() != null && Math.abs(this.theEyeEntity.m_5448_().m_20185_() - this.theEyeEntity.m_20185_()) < 3.0 && Math.abs(this.theEyeEntity.m_5448_().m_20189_() - this.theEyeEntity.m_20189_()) < 3.0) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (this.willCollide(vec3d, Mth.m_14165_((double)d))) {
                    this.theEyeEntity.m_20256_(this.theEyeEntity.m_20184_().m_82549_(vec3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean willCollide(Vec3 direction, int steps) {
            AABB box = this.theEyeEntity.m_20191_();
            for (int i = 1; i < steps; ++i) {
                box = box.m_82383_(direction);
                if (this.theEyeEntity.m_9236_().m_45756_((Entity)this.theEyeEntity, box)) continue;
                return false;
            }
            return true;
        }
    }

    private class ShootBulletGoal
    extends Goal {
        private int counter;
        private final TheEyeEntity theEyeEntity;

        public ShootBulletGoal(TheEyeEntity theEyeEntity2) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.theEyeEntity = theEyeEntity2;
        }

        public boolean m_8036_() {
            ++this.counter;
            LivingEntity livingEntity = this.theEyeEntity.m_5448_();
            if (livingEntity != null && livingEntity.m_6084_() && this.theEyeEntity.m_21223_() < this.theEyeEntity.m_21233_() / 2.0f && this.counter >= 400) {
                return this.theEyeEntity.m_9236_().m_46791_() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.theEyeEntity.m_5448_();
            if (livingEntity != null) {
                int additions = 0;
                if (this.theEyeEntity.m_21223_() < this.theEyeEntity.m_21233_() / 4.0f) {
                    additions = 1;
                }
                for (int i = 0; i < 3 + additions; ++i) {
                    this.theEyeEntity.m_9236_().m_7967_((Entity)new TinyEyeEntity(this.theEyeEntity.m_9236_(), (LivingEntity)this.theEyeEntity, (Entity)livingEntity, Direction.Axis.Y));
                    this.theEyeEntity.m_5496_(SoundEvents.f_12417_, 2.0f, (this.theEyeEntity.f_19796_.m_188501_() - this.theEyeEntity.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
                super.m_8037_();
                this.counter = this.theEyeEntity.f_19796_.m_188503_(12) * 20;
            }
        }
    }

    private class FireBeamGoal
    extends Goal {
        private final TheEyeEntity theEye;
        private int beamTicks;

        public FireBeamGoal(TheEyeEntity theEye) {
            this.theEye = theEye;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.theEye.m_5448_();
            return livingEntity != null && livingEntity.m_6084_();
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.theEye.m_5448_();
            if (this.theEye.gotDamage()) {
                return false;
            }
            return super.m_8045_() && this.theEye.m_20280_((Entity)this.theEye.m_5448_()) > 8.0 && livingEntity != null && livingEntity.m_20186_() < this.theEye.m_20186_();
        }

        public void m_8056_() {
            this.beamTicks = -20;
            this.theEye.m_21573_().m_26573_();
            this.theEye.m_21563_().m_24960_((Entity)this.theEye.m_5448_(), 90.0f, 90.0f);
            this.theEye.f_19812_ = true;
        }

        public void m_8041_() {
            this.theEye.setBeamTarget(0);
            this.theEye.m_6710_(null);
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.theEye.m_5448_();
            this.theEye.m_21563_().m_24960_((Entity)livingEntity, 90.0f, 90.0f);
            if (!this.theEye.m_142582_((Entity)livingEntity)) {
                this.theEye.m_6710_(null);
            } else {
                ++this.beamTicks;
                if (this.beamTicks == 0) {
                    this.theEye.setBeamTarget(this.theEye.m_5448_().m_19879_());
                } else if (this.beamTicks >= this.theEye.getWarmupTime()) {
                    float f = 4.0f;
                    if (this.theEye.m_9236_().m_46791_() == Difficulty.HARD) {
                        f += 1.0f;
                    }
                    livingEntity.m_6469_(this.theEye.m_269291_().m_269425_(), f);
                    livingEntity.m_6469_(this.theEye.m_269291_().m_269333_((LivingEntity)this.theEye), (float)this.theEye.m_21133_(Attributes.f_22281_));
                    this.theEye.m_6710_(null);
                }
                super.m_8037_();
            }
        }
    }

    private class DuplicateAttack
    extends Goal {
        private int cooldown;
        private final TheEyeEntity theEyeEntity;

        public DuplicateAttack(TheEyeEntity theEyeEntity2) {
            this.theEyeEntity = theEyeEntity2;
        }

        public boolean m_8036_() {
            ++this.cooldown;
            LivingEntity livingEntity = this.theEyeEntity.m_5448_();
            if (livingEntity != null && livingEntity.m_6084_() && this.theEyeEntity.duplicationTimer <= 0 && this.cooldown >= 600) {
                List list = this.theEyeEntity.m_9236_().m_6443_(TheEyeEntity.class, this.theEyeEntity.m_20191_().m_82400_(120.0), EntitySelector.f_20406_);
                if (!list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        if (((TheEyeEntity)((Object)list.get((int)i))).duplicationTimer <= 0) continue;
                        this.cooldown = 0;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public void m_8056_() {
            LivingEntity livingEntity = this.theEyeEntity.m_5448_();
            if (livingEntity != null) {
                block0: for (int i = 0; i < 2; ++i) {
                    for (int k = 0; k < 10; ++k) {
                        BlockPos pos = this.theEyeEntity.m_20183_();
                        pos = pos.m_7918_(pos.m_123341_() - livingEntity.m_20183_().m_123341_() + this.theEyeEntity.m_9236_().m_213780_().m_188503_(6) * 5, 0, pos.m_123343_() - livingEntity.m_20183_().m_123343_() + this.theEyeEntity.m_9236_().m_213780_().m_188503_(6) * 5);
                        if (!this.theEyeEntity.m_9236_().m_8055_(pos).m_60795_() || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (LevelReader)this.theEyeEntity.m_9236_(), (BlockPos)pos, EntityInit.THE_EYE)) continue;
                        TheEyeEntity theEyeEntityDuplicate = (TheEyeEntity)EntityInit.THE_EYE.m_20615_(this.theEyeEntity.m_9236_());
                        theEyeEntityDuplicate.m_20035_(pos, this.theEyeEntity.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                        theEyeEntityDuplicate.m_6518_((ServerLevelAccessor)((ServerLevel)this.theEyeEntity.m_9236_()), this.theEyeEntity.m_9236_().m_6436_(pos), MobSpawnType.EVENT, null, null);
                        theEyeEntityDuplicate.duplicationTimer = 800;
                        theEyeEntityDuplicate.m_6703_(livingEntity);
                        theEyeEntityDuplicate.m_21051_(Attributes.f_22276_).m_22100_(100.0);
                        this.theEyeEntity.m_9236_().m_7967_((Entity)theEyeEntityDuplicate);
                        for (int u = 0; u < 50; ++u) {
                            double d = theEyeEntityDuplicate.m_20185_() - 1.5 + (double)(this.theEyeEntity.m_9236_().m_213780_().m_188501_() * 3.0f);
                            double e = (float)theEyeEntityDuplicate.m_20187_() + this.theEyeEntity.m_9236_().m_213780_().m_188501_() * 0.1f;
                            double f = theEyeEntityDuplicate.m_20189_() - 1.5 + (double)(this.theEyeEntity.m_9236_().m_213780_().m_188501_() * 3.0f);
                            double g = (double)this.theEyeEntity.m_9236_().m_213780_().m_188501_() * 0.2;
                            double h = (double)this.theEyeEntity.m_9236_().m_213780_().m_188501_() * 0.1;
                            double l = (double)this.theEyeEntity.m_9236_().m_213780_().m_188501_() * 0.2;
                            ((ServerLevel)this.theEyeEntity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, d, e, f, 4, g, h, l, 1.0);
                        }
                        continue block0;
                    }
                }
            }
            this.m_8041_();
        }

        public void m_8041_() {
            this.cooldown = 0;
        }
    }

    private class FlyRandomlyGoal
    extends Goal {
        private final TheEyeEntity theEyeEntity;

        public FlyRandomlyGoal(TheEyeEntity theEyeEntity2) {
            this.theEyeEntity = theEyeEntity2;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double f;
            double e;
            MoveControl moveControl = this.theEyeEntity.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d = moveControl.m_25000_() - this.theEyeEntity.m_20185_();
            double g = d * d + (e = moveControl.m_25001_() - this.theEyeEntity.m_20186_()) * e + (f = moveControl.m_25002_() - this.theEyeEntity.m_20189_()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.theEyeEntity.m_217043_();
            double d = this.theEyeEntity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double e = this.theEyeEntity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 1.2f);
            double f = this.theEyeEntity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.theEyeEntity.m_21566_().m_6849_(d, e, f, 1.0);
        }
    }

    private class LookAtTargetGoal
    extends Goal {
        private final TheEyeEntity theEyeEntity;

        public LookAtTargetGoal(TheEyeEntity theEyeEntity2) {
            this.theEyeEntity = theEyeEntity2;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.theEyeEntity.getInvulnerableTimer() <= 0;
        }

        public void m_8037_() {
            if (this.theEyeEntity.m_5448_() == null) {
                Vec3 vec3d = this.theEyeEntity.m_20184_();
                this.theEyeEntity.m_146922_(-((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f);
                this.theEyeEntity.f_20883_ = this.theEyeEntity.m_146908_();
            } else {
                LivingEntity livingEntity = this.theEyeEntity.m_5448_();
                if (livingEntity.m_20280_((Entity)this.theEyeEntity) < 4096.0) {
                    double e = livingEntity.m_20185_() - this.theEyeEntity.m_20185_();
                    double f = livingEntity.m_20189_() - this.theEyeEntity.m_20189_();
                    if (Math.abs(this.theEyeEntity.m_5448_().m_20185_() - this.theEyeEntity.m_20185_()) > 0.3 && Math.abs(this.theEyeEntity.m_5448_().m_20189_() - this.theEyeEntity.m_20189_()) > 0.3) {
                        this.theEyeEntity.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                        this.theEyeEntity.f_20883_ = this.theEyeEntity.m_146908_();
                    }
                }
            }
        }
    }
}

